C+
C NAME:
C	smei_htm_starmask
C PURPOSE:
C	Read in star masks for htm indexing.
C CALLING SEQUENCE
	subroutine smei_htm_starmask(n_eq, mask_eq, n_pl, mask_pl)
C INCLUDE:
	include		'filparts.h'
	include		'dirspec.h'
	include		'ftspar.h'
C CALLS:
C	iFilePath, Say, FTNOPN, say_fts, iGetLun, iFreeLun
C-
	    integer	n_eq
	    integer	mask_eq(*)
	    integer	n_pl
	    integer	mask_pl(*)

	character	cSay*17			/'smei_get_starmask'/
	character	cSeverity		/'E'/
	character	cFile*(FIL__LENGTH)

	logical		anyf
	integer		nAxes(2)

	i = iFilePath(cEnvi(:iEnvi)//'SMEIDB',0,' ','starmask.fts.gz',cFile)

	iU = iGetLun(cFile)

	istat = 0

	call Say(cSay,'I','#'//cFile,'is star mask file')

	call FTNOPN(iU, cFile, FTS__READONLY, istat)
	if (istat .ne. 0) call say_fts(cSay,cSeverity,istat)

	call FTGISZ(iU, 2, nAxes, istat)
	if (istat .ne. 0) call say_fts(cSay,cSeverity,istat)

	n = nAxes(1)*nAxes(2)
	if (n .ne. n_eq) call Say(cSay,'E','n_eq','wrong array size')

	anyf = .FALSE.
	call FTGPVJ(iU, 1, 1, n, 0.0, mask_eq, anyf, istat)
	if (istat .ne. 0) call say_fts(cSay,cSeverity,istat)

	call FTMAHD(iU, 2, ihdutype, istat)

	call FTGISZ(iU, 2, nAxes, istat)
	if (istat .ne. 0) call say_fts(cSay,cSeverity,istat)

	n = nAxes(1)*nAxes(2)
	if (n .ne. n_pl) call Say(cSay,'E','n_pl','wrong array size')

	anyf = .FALSE.
	call FTGPVJ(iU, 1, 1, n, 0.0, mask_pl, anyf, istat)
	if (istat .ne. 0) call say_fts(cSay,cSeverity,istat)

	call FTMAHD(iU, 3, ihdutype, istat)

	call FTGISZ(iU, 2, nAxes, istat)
	if (istat .ne. 0) call say_fts(cSay,cSeverity,istat)

	n = nAxes(1)*nAxes(2)
	if (n .ne. n_pl) call Say(cSay,'E','n_pl','wrong array size')

	anyf = .FALSE.
	call FTGPVJ(iU, 1, 1, n, 0.0, mask_pl(n+1), anyf, istat)
	if (istat .ne. 0) call say_fts(cSay,cSeverity,istat)

	call FTCLOS(iU, istat)
	if (istat .ne. 0) call say_fts(cSay,cSeverity,istat)

	iU = iFreeLun(iU)

	return
	end
