	subroutine smei_htm_eqscan(ra_min,ra_max,dec_min,dec_max,
     &		d_eq ,n_eq ,nxeq ,nyeq ,cxeq ,cyeq ,
     &		d_eq_,n_eq_,nxeq_,nyeq_,cxeq_,cyeq_,	xmg_eq,img_eq,row)

	    double precision	ra_min
	    double precision	ra_max
	    double precision	dec_min
	    double precision	dec_max
	    double precision	d_eq
	    integer		n_eq
	    integer		nxeq
	    integer		nyeq
	    double precision	cxeq
	    double precision	cyeq
	    double precision	d_eq_
	    integer		n_eq_
	    integer		nxeq_
	    integer		nyeq_
	    double precision	cxeq_
	    double precision	cyeq_
	    real		xmg_eq(*)
	    real		img_eq(*)
	    real		row(*)

	ip (i,j) = (j-1)*nxeq +i
	ip_(i,j) = (j-1)*nxeq_+i

	cxeq_ = cxeq
	cyeq_ = cyeq

	d_eq_ = d_eq

	ilow  = nint(cxeq+ra_min *d_eq+0.5)
	ihigh = nint(cxeq+ra_min *d_eq-0.5)

	jlow  = nint(cyeq+dec_min*d_eq+0.5)
	jhigh = nint(cyeq+dec_min*d_eq-0.5)

	if (ilow .gt. ihigh) then

	    ! The requested RA range bridges the 0/360 deg meridian
	    ! Shuffle the array to put ilow in the first column

	    n = nxeq-ilow+1	! # grid points between ra_min and 360 deg

	    do j=1,nyeq
		call ArrR4Copy(ilow-1,xmg_eq(ip(1,j)),row)
		call ArrR4Copy(n,xmg_eq(ip(ilow,j)),xmg_eq(ip(1,j)))
		call ArrR4Copy(ilow-1,row,xmg_eq(ip(n+1,j)))		    
	    end do

	    cxeq_ = cxeq_-ilow+1

	    ilow  = 1
	    ihigh = ihigh+n

	end if

	nxeq_ = ihigh-ilow+1
	nyeq_ = jhigh-jlow+1

	n_eq_ = nxeq_*nyeq_

	if (n_eq_ .gt. 0 .and. n_eq_ .ne. n_eq) then

	    do j=1,nyeq_
	 	do i=1,nxeq_
		    xmg_eq(ip_(i,j)) = xmg_eq(ip(ilow+i-1,jlow+j-1))
		end do
	    end do

	    cxeq_ = cxeq_-ilow+1
	    cyeq_ = cyeq_-jlow+1

	end if

	return
	end

	subroutine smei_htm_plscan(ra_min,ra_max,dec_min,dec_max,
     &		d_pl ,n_pl ,nxpl ,nypl ,cxpl ,cypl ,
     &		d_pl_,n_pl_,nxpl_,nypl_,cxpl_,cypl_,	xmg_pl,img_pl)

	    double precision	ra_min
	    double precision	ra_max
	    double precision	dec_min
	    double precision	dec_max
	    double precision	d_pl
	    integer		n_pl
	    integer		nxpl
	    integer		nypl
	    double precision	cxpl
	    double precision	cypl
	    double precision	d_pl_(2)
	    integer		n_pl_(2)
	    integer		nxpl_(2)
	    integer		nypl_(2)
	    double precision	cxpl_(2)
	    double precision	cypl_(2)
	    real		xmg_pl(*)
	    real		img_pl(*)

	double precision	px
	double precision	py
	double precision	dmin
	double precision	dmax
	double precision	PLMaxRad

	ip (i,j,k) = (k-1)*n_pl    +(j-1)*nxpl    +i
	ip_(i,j,k) = (k-1)*n_pl_(1)+(j-1)*nxpl_(k)+i

	px = max(cxpl-0.5d0, nxpl+0.5d0-cxpl)/d_pl
	py = max(cypl-0.5d0, nypl+0.5d0-cypl)/d_pl
	PLMaxRad = dsqrt(px*px+py*py)

	do k=1,2

	    ipm = 3-2*k		! +1 at North Pole, -1 at South Pole

	    dmin = d_pl*(90d0-ipm*dec_min)
	    dmax = d_pl*(90d0-ipm*dec_max)

	    i1 = nint(cxpl+dmin*dcosd(ra_min))
	    i2 = nint(cxpl+dmin*dcosd(ra_max))
	    i3 = nint(cxpl+dmax*dcosd(ra_min))
	    i4 = nint(cxpl+dmax*dcosd(ra_max))

	    j1 = nint(cypl+dmin*dsind(ra_min))
	    j2 = nint(cypl+dmin*dsind(ra_max))
	    j3 = nint(cypl+dmax*dsind(ra_min))
	    j4 = nint(cypl+dmax*dsind(ra_max))

	    ilow  = min(i1,i2,i3,i4)
	    ihigh = max(i1,i2,i3,i4)

	    jlow  = min(j1,j2,j3,j4)
	    jhigh = max(j1,j2,j3,j4)

	    if ( (ra_min .le. ra_max .and. (ra_min .le.   0d0 .and.   0d0 .le. ra_max)) .or.
     &		 (ra_min .gt. ra_max .and. (ra_min .le.   0d0 .or.    0d0 .le. ra_max)) )
     &		ihigh = (2-k)*nint(cxpl+dmin)+(k-1)*nint(cxpl+dmax)

	    if ( (ra_min .le. ra_max .and. (ra_min .le.  90d0 .and.  90d0 .le. ra_max)) .or.
     &		 (ra_min .gt. ra_max .and. (ra_min .le.  90d0 .or.   90d0 .le. ra_max)) )
     &		jhigh = (2-k)*nint(cypl+dmin)+(k-1)*nint(cypl+dmax)

	    if ( (ra_min .le. ra_max .and. (ra_min .le. 180d0 .and. 180d0 .le. ra_max)) .or.
     &		 (ra_min .gt. ra_max .and. (ra_min .le. 180d0 .or.  180d0 .le. ra_max)) )
     &		ilow = (2-k)*nint(cxpl-dmin)+(k-1)*nint(cxpl-dmax)

	    if ( (ra_min .le. ra_max .and. (ra_min .le. 270d0 .and. 270d0 .le. ra_max)) .or.
     &		 (ra_min .gt. ra_max .and. (ra_min .le. 270d0 .or.  270d0 .le. ra_max)) )
     &		jlow = (2-k)*nint(cypl-dmin)+(k-1)*nint(cypl-dmax)

	    ilow  = max(ilow ,1)
	    ihigh = max( min(ihigh,nxpl), ilow-1 )

	    jlow  = max(jlow ,1)
	    jhigh = max( min(jhigh,nypl), jlow-1 )

	    d_pl_(i) = d_pl

	    cxpl_(k) = cxpl
	    cypl_(k) = cypl

	    nxpl_(k) = ihigh-ilow+1
	    nypl_(k) = jhigh-jlow+1

	    n_pl_(k) = nxpl_(k)*nypl_(k)

	    if (n_pl_(k) .gt. 0 .and. n_pl_(k) .ne. n_pl) then

		do j=1,nypl_(k)
		    do i=1,nxpl_(k)
			xmg_pl(ip_(i,j,k)) = xmg_pl(ip(ilow+i-1,jlow+j-1,k))
		    end do
		end do

		cxpl_(k) = cxpl_(k)-ilow+1
		cypl_(k) = cypl_(k)-jlow+1

	    end if

	end do

	return
	end
