C+
C NAME:
C	smei_htm_node2sky
C PURPOSE:
C	Drop node on skymap (equatorial or polar maps)
C CALLING SEQUENCE:
	subroutine smei_htm_node2sky(px,py,rval,xmg_eq,img_eq,xmg_pl,img_pl)
C INPUTS:
C	px,py		double precision	RA,dec of HTM node
C	rval		real			response of node (return value of
C						smei_htm_combine.
C	xmg_eq(*)	real			accumulated totals for equatorial map
C	img_eq(*)	integer			total counts for equatorial map
C	xmg_pl(*)	real			accumulated totals for two polar maps
C	img_pl(*)	integer			total counts for two polar maps
C OUTPUTS:
C	xmg_eq(*)	real			updated sky map arrays
C	img_eq(*)	integer
C	xmg_pl(*)	real
C	img_pl(*)	integer
C INCLUDE:
	include		'smei_htm_dim.h'
C SEE ALSO:
C	smei_htm_combine
C PROCEDURE:
C MODIFICATION HISTORY:
C	JAN-2006, Paul Hick (UCSD/CASS; pphick@ucsd.edu)
C-
	    double precision	px
	    double precision	py
	    real		rval
	    integer		img_eq(*)
	    real		xmg_eq(*)
	    integer		img_pl(*)
	    real		xmg_pl(*)

	double precision	dval
	double precision	rx
	double precision	ry

	double precision	PLMaxRad

	double precision	dsind			! Neede for GNU compiler
	double precision	dcosd

	ip_eq (i,j  ) =	 (j-1)*HTM__NXEQ+i			! Used to index equatorial map array
	ip_pl (i,j,k) = ((k-1)*HTM__NYPL+(j-1))*HTM__NXPL+i	! Used to index polar map arrays
	    
	! px = right ascension, py = declination

	! Dec -60+delta -> j = nint(   0.5+10*delta) = 1
	! Dec +60-delta -> j = nint(1200.5-10*delta) = 1200

	j = nint(HTM__CYEQ+py*HTM__D_EQ)

	if (1 .le. j .and. j .le. HTM__NYEQ) then

	    ! RA =   0+delta -> i = nint(   0.5+10*delta) = 1
	    ! RA = 360-delta -> i = nint(3600.5-10*delta) = 3600
	    ! RA =   0 -> i = nint(   0.5) = 1
	    ! RA = 360 -> i = nint(3600.5) = 3601
	    ! So as long as 0 <= ra < 360 -> 1 <= i <= 3600

	    i = nint(HTM__CXEQ+px*HTM__D_EQ)

	    ! Make sure the index is valid. If all is well this is always
	    ! the case, so it's probably redundant.

	    if (i .lt. 1 .or. i .gt. HTM__NXEQ) then
		write (*,*) ' RA=',px,' Dec=',py
		stop 'smei_htm_node2sky: darn'
	    end if

	    i = ip_eq(i,j)
	    img_eq(i) = img_eq(i)+1
	    xmg_eq(i) = xmg_eq(i)+rval

	end if

	! k=1: North Polar plot (>  33 degrees)
	! k=2: South Polar plot (< -33 degrees)

	! In the polar maps the maximum polar distance is reached in the
	! corners of the array. Find the corner farthest away from the pole
	! and calculate its polar distance.

	rx = max(HTM__CXPL-0.5d0, HTM__NXPL+0.5d0-HTM__CXPL)/HTM__D_PL
	ry = max(HTM__CYPL-0.5d0, HTM__NYPL+0.5d0-HTM__CYPL)/HTM__D_PL
	PLMaxRad = dsqrt(rx*rx+ry*ry)

	dval = 90d0-dabs(py)

	if (dval .le. PLMaxRad) then

	    dval = HTM__D_PL*dval

	    i = nint(HTM__CXPL+dval*dcosd(px))
	    if (1 .le. i .and. i .le. HTM__NXPL) then

		j = nint(HTM__CYPL+dval*dsind(px))
		if (1 .le. j .and. j .le. HTM__NYPL) then

		    i = ip_pl(i,j,(3-sign(1,int(py)))/2) ! 1 for North, 2 for South
		    img_pl(i) = img_pl(i)+1
		    xmg_pl(i) = xmg_pl(i)+rval

		end if

	    end if

	end if

	return
	end
