C+
C NAME:
C	smei_htm_go
C PURPOSE:
C	Decide on whether to continue processing frames for given orbit
C CALLING SEQUENCE:
	logical function smei_htm_go(bOverwrite,bCheckVersion,cFile,version,bExists)
C INPUTS:
C	bOverwrite		logical
C	bCheckVersion		logical
C	cFile			character*(*)
C	version			double precision
C OUTPUTS:
C	bExists			logical
C	smei_htm_go		logical
C INCLUDE:
	include		'filparts.h'
	include		'ftspar.h'
C CALLS:
C	iSearch, Say, iGetLun, iFreeLun, say_fts
C	FTNOPN, FTGKYD, FTCLOS
C PROCEDURE:
C	Called when the first good frame for an orbits has been found to decide
C	whether the orbit needs to be processed and a skymap is to be created.
C >	If the skymap does not exist then a skymap is created (bExists=.FALSE.;
C	smei_htm_go=.TRUE.)
C >	If the skymap already exists then bOverwrite, bCheckVersion and version
C	determine what happens:
C	1. If bOverwrite is .TRUE. then the skymap is overwritten (bExists=.TRUE.,
C	smei_htm_go=.TRUE.)
C	2. If bCheckversion is .TRUE. and version is larger than the version of
C	the skymap then the skymap is overwritten (bExists=.TRUE.;
C	smei_htm_go=.TRUE.)
C	3. If bOverwrite=bCheckVersion=.FALSE. then the skymap is not overwritten
C	(bExists=.TRUE.; bGo=.FALSE.)
C MODIFICATION HISTORY:
C	DEC-2005, Paul Hick (UCSD/CASS; pphick@ucsd.edu)
C-
	    logical		bOverwrite
	    logical		bCheckVersion
	    character		cFile*(*)
	    double precision	version
	    logical		bExists

	character		cSay*11		/'smei_htm_go'/
	character		cSeverity	/'E'/

	character		cTmp*(FIL__LENGTH)
	character		cStr*(FIL__LENGTH)
	logical			bGo
	double precision 	old_version

	bExists = iSearch(11,cFile,cTmp) .ne. 0

	if (bExists) then

	    if (bOverwrite) then

		call Say(cSay,'W','#'//cTmp,'exists and is overwritten')
		bGo = .TRUE.		! Keep going if -overwrite is set

	    else if (bCheckVersion) then! Check version number

		iU = iGetLun(cTmp)
		istat = 0

		call FTNOPN(iU, cTmp, FTS__READONLY, istat)
		if (istat .ne. 0) call say_fts(cSay,cSeverity,istat)

		call FTGKYD(iU, 'SMEI_HTM', old_version, cStr, istat)
		if (istat .ne. 0) call say_fts(cSay,cSeverity,istat)

		call FTCLOS(iU, istat)
		if (istat .ne. 0) call say_fts(cSay,cSeverity,istat)

		iU = iFreeLun(iU)

		bGo = version .gt. old_version
		if (bGo) call Say(cSay,'W','#'//cTmp,
     &			'has lower version number and is overwritten')

	    else			! File exists, and version doesn't matter

		call Say(cSay,'W','#'//cTmp,'exists already')
		bGo = .FALSE.		! Don't continue processing

	    end if

	else

	    bGo = .TRUE.		! Keep going if file doesn't exist

	end if

	smei_htm_go = bGo

	return
	end
