C+
C NAME:
C	smei_htm_dim
C PURPOSE:
C	Parameter definitions for sizes of skymaps
C CALLING SEQUENCE:
C	include 'smei_htm_dim.h'
C PROCEDURE:
C	Equatorial map covers [0,360] in RA and [-60,60] in declination
C	at 0.1 degree resolution.
C	The north and polar maps are polar maps out to 40 degrees from
C	the pole in two perpendicular directions with 0.1 degree resolution.
C MODIFICATION HISTORY:
C	JAN-2006, Paul Hick (UCSD/CASS; pphick@ucsd.edu)
C-
	! Highest HTM level  used

	integer		 HTM__LEVEL
	parameter	(HTM__LEVEL = 12)

	! Number of nodes (HTM triangles) per pixel in mode 0

	integer		 HTM__NODES_PER_PIXEL
	parameter	(HTM__NODES_PER_PIXEL = 200)

	! Number of nodes (HTM triangles) per frame in mode 0

	integer		 HTM__NODES
	parameter	(HTM__NODES = 1600000)

	! Number of votes

	integer		 HTM__VOTES
	parameter	(HTM__VOTES = 70000000)

	! Identifier for empty location in pool arrays

	integer		 HTM__NO_NODE
	parameter	(HTM__NO_NODE = 0)

	!======================================
	! Locators for quantities for all nodes

	integer		 HTM__NODE_NTOP		! Highest occupied node index in arrays
	parameter	(HTM__NODE_NTOP	=1)

	integer		 HTM__NODE_NSLOT	! Number of different nodes
	parameter	(HTM__NODE_NSLOT=2)

	integer		 HTM__NODE_NVOTE	! Total number of votes for all nodes
	parameter	(HTM__NODE_NVOTE=3)

	integer		 HTM__NODE_NSORT
	parameter	(HTM__NODE_NSORT=4)

	integer		 HTM__NODE_NEMPTY
	parameter	(HTM__NODE_NEMPTY=5)

	integer		 HTM__NODE_IEMPTY
	parameter	(HTM__NODE_IEMPTY=6)

	integer		 HTM__NODE_NTOPMAX
	parameter	(HTM__NODE_NTOPMAX=7)

	integer		 HTM__NODE_NVOTEMAX
	parameter	(HTM__NODE_NVOTEMAX=8)

	integer		 HTM__NODE_N
	parameter	(HTM__NODE_N	=8)

	!======================================

	integer		 HTM__POOL_N
	parameter	(HTM__POOL_N = 2)

	integer		 HTM__POOL_S
	parameter	(HTM__POOL_S=HTM__NODE_N*HTM__POOL_N)


	integer		 HTM__NFINE
	parameter	(HTM__NFINE = 2)

	! Equatorial map covers [0,360] in RA and [-60,60] in declination at 0.1 degree resolution.

	integer		 HTM__NXEQ
	parameter	(HTM__NXEQ = 3600)	! # bins covering [0,360]; bin centers at i+0.5, i=0,359

	integer		 HTM__NYEQ
	parameter	(HTM__NYEQ = 1200)	! # bins covering [-60,60]; bin centers at -60+j+0.5, j=0,119

	integer		 HTM__N_EQ		! Total # sky bins in equatorial map
	parameter	(HTM__N_EQ = HTM__NXEQ*HTM__NYEQ)

	double precision HTM__CXEQ
	parameter	(HTM__CXEQ = 0.5d0)

	double precision HTM__CYEQ		! Location equator
	parameter	(HTM__CYEQ = 0.5d0*(1+HTM__NYEQ))

	double precision HTM__D_EQ
	parameter	(HTM__D_EQ = HTM__NXEQ/360d0)! # bins per degree in RA

	! The north and polar maps are polar maps out to 40 degrees from the pole in two
	! perpendicular directions with 0.1 degree resolution.

	integer		 HTM__NXPL
	parameter	(HTM__NXPL = 800)	! # bins in first (X) dimension of polar plot

	integer		 HTM__NYPL
	parameter	(HTM__NYPL = 800)	! # bins in second (Y) dimension of polar plot

	integer		 HTM__N_PL		! Total # of sky bins in polar maps
	parameter	(HTM__N_PL = HTM__NXPL*HTM__NYPL)

	double precision HTM__CXPL		! X-coordinate of location of pole
	parameter	(HTM__CXPL = 0.5d0*(1+HTM__NXPL))

	double precision HTM__CYPL		! Y-coordinate of location of pole
	parameter	(HTM__CYPL = 0.5d0*(1+HTM__NYPL))

	double precision HTM__D_PL
	parameter	(HTM__D_PL = 10d0)	! # bins per degree in polar distance angle.


	! Equatorial map covers [0,360] in RA and [-60,60] in declination at 0.1 degree resolution.

	integer		 HTM__NXEQ_FINE		! # bins covering [0,360]; bin centers at i+0.5, i=0,3599
	parameter	(HTM__NXEQ_FINE = HTM__NXEQ*HTM__NFINE)

	integer		 HTM__NYEQ_FINE		! # bins covering [-60,60]; bin centers at -60+j+0.5, j=0,1199
	parameter	(HTM__NYEQ_FINE = HTM__NYEQ*HTM__NFINE)

	integer		 HTM__N_EQ_FINE		! Total # sky bins in equatorial map
	parameter	(HTM__N_EQ_FINE = HTM__NXEQ_FINE*HTM__NYEQ_FINE)

	double precision HTM__CXEQ_FINE
	parameter	(HTM__CXEQ_FINE = 0.5d0)

	double precision HTM__CYEQ_FINE		! Location equator
	parameter	(HTM__CYEQ_FINE = 0.5d0*(1+HTM__NYEQ_FINE))

	double precision HTM__D_EQ_FINE
	parameter	(HTM__D_EQ_FINE = HTM__NXEQ_FINE/360d0)! # bins per degree in RA

	! The north and polar maps are polar maps out to 40 degrees from the pole in two
	! perpendicular directions with 0.1 degree resolution.

	integer		 HTM__NXPL_FINE		! # bins in first (X) dimension of polar plot
	parameter	(HTM__NXPL_FINE = HTM__NXPL*HTM__NFINE)

	integer		 HTM__NYPL_FINE		! # bins in second (Y) dimension of polar plot
	parameter	(HTM__NYPL_FINE = HTM__NYPL*HTM__NFINE)

	integer		 HTM__N_PL_FINE		! Total # of sky bins in polar maps
	parameter	(HTM__N_PL_FINE = HTM__NXPL_FINE*HTM__NYPL_FINE)

	double precision HTM__CXPL_FINE		! X-coordinate of location of pole
	parameter	(HTM__CXPL_FINE = 0.5d0*(1+HTM__NXPL_FINE))

	double precision HTM__CYPL_FINE		! Y-coordinate of location of pole
	parameter	(HTM__CYPL_FINE = 0.5d0*(1+HTM__NYPL_FINE))

	double precision HTM__D_PL_FINE		! # bins per degree in polar distance angle.
	parameter	(HTM__D_PL_FINE = HTM__D_PL*HTM__NFINE)


	!=================================
	! Low resolution sky maps
	! Initialized in smei_htm_init
	! Filled in smei_htm_sky
	! Written to disk in smei_htm_out

	integer		 HTM__NXLO
	parameter	(HTM__NXLO = 720)

	integer		 HTM__NYLO
	parameter	(HTM__NYLO = 360)

	integer		 HTM__N_LO
	parameter	(HTM__N_LO = HTM__NXLO*HTM__NYLO)

	double precision HTM__CXLO
	parameter	(HTM__CXLO = 0.5d0)

	double precision HTM__CYLO		! Location equator
	parameter	(HTM__CYLO = 0.5d0*(1+HTM__NYLO))

	double precision HTM__D_LO		! # bins per degree in RA
	parameter	(HTM__D_LO = HTM__NXLO/360d0)

	! Info for low resolution maps (used in filling up array lowres, and writing Fits file)

	integer		 HTM__LO_SKY
	parameter	(HTM__LO_SKY  = 1)

	integer		 HTM__LO_TIME
	parameter	(HTM__LO_TIME = 2)

	integer		 HTM__LO_PSFN
	parameter	(HTM__LO_PSFN = 3)

	integer		 HTM__LO_PSFE
	parameter	(HTM__LO_PSFE = 4)

	integer		 HTM__LO_CUT
	parameter	(HTM__LO_CUT  = 5)

	integer		 HTM__LO_FRAC
	parameter	(HTM__LO_FRAC = 6)

	integer		 HTM__LO_ROTX
	parameter	(HTM__LO_ROTX = 7)

	integer		 HTM__LO_ROTY
	parameter	(HTM__LO_ROTY = 8)

	integer		 HTM__LO_SECS
	parameter	(HTM__LO_SECS = 9)

	integer		 HTM__LO_HIT
	parameter	(HTM__LO_HIT  = 10)

	integer		 HTM__LO_CNT
	parameter	(HTM__LO_CNT  = 11)

	integer		 HTM__LO_NMAP
	parameter	(HTM__LO_NMAP = 11)

	! Dimensions of glare multiplier map

	integer		 HTM__NX_GLARE
	parameter	(HTM__NX_GLARE =  90)

	integer		 HTM__NY_GLARE
	parameter	(HTM__NY_GLARE = 180)

	! Number of pixels inside FOV for mode 0

	integer		 HTM__NFOV
	parameter	(HTM__NFOV = 62000)
