C+
C NAME:
C	smei_htm_combine
C PURPOSE:
C	Combines in into a single value.
C CATEGORY:
C	smei/camera/for/htm
C CALLING SEQUENCE:
	!integer function smei_htm_combine(iType,bKeepGlitch,iSilent,count,val,flag,pos,rgood,rbad,badpix)
	integer function smei_htm_combine(iType,bKeepGlitch,iSilent,count,val,flag,rgood,rbad,badpix)
C INPUTS:
C	iType			integer
C	bKeepGlitch		logical suppress glitch removal
C	count			integer	number of votes
C	val(*)			real	response for all votes
C OUTPUTS:
C	smei_htm_combine
C	rgood			real	final response for selected node,
C					calculated from all votes
C INCLUDE:
	include		'filparts.h'
	include		'smei_htm_dim.h'
C PROCEDURE:
C MODIFICATION HISTORY:
C	JAN-2006, Paul Hick (UCSD/CASS; pphick@ucsd.edu)
C-
	    integer	iType
	    logical	bKeepGlitch
	    integer	iSilent
	    integer	count
	    real	val (*)
	    integer*1	flag(*)
	    !integer	pos (*)
	    real	rgood
	    real	rbad
	    integer	badpix(*)

	character	cSay*11			/'htm_combine'/
	character	cStr*(FIL__LENGTH)

	integer		Str2Str

	integer		nvote_min		/1/

	parameter	(max_votes = 300)

	!real		vdiff	 (max_votes)
	integer		indx	 (max_votes)

	real		val_sort (max_votes)
	integer		flag_sort(max_votes)
	!integer	pos_sort (max_votes)

	badval = BadR4()

	if (count .gt. max_votes) stop 'htm_combine, max_votes too small'

	! Sort arrays

	call IndexR4(1,count,1,count,val,indx)
	do i=1,count
	    val_sort (i) = val (indx(i))
	    flag_sort(i) = flag(indx(i))
	    !pos_sort (i) = pos (indx(i))
	end do

	! Count number of votes with the near_star flag set.

	near_star = 0
	do i=1,count
	    if (btest(flag_sort(i),0)) near_star = near_star+1
	end do

	if (near_star .ne. 0) then
	    i = 0
	    i = i+Int2Str(near_star	, cStr(i+1:))
	    i = i+Str2Str('/'		, cStr(i+1:))
	    i = i+Int2Str(count		, cStr(i+1:))+1
	    i = i+Str2Str('"near star"'	, cStr(i+1:))
	    if (near_star .lt. 0.5*count) then
		!if (iSilent .lt. 1) call Say(cSay,'W','marked', cStr(:i)//', IGNORED !')
		near_star = 0
	    else
		!if (iSilent .lt. 1) call Say(cSay,'W','marked', cStr)
		near_star = 1
	    end if
	end if

	if (count .lt. nvote_min) then		! Not enough votes: reject node

	    rmedian = badval

	    nlow    = 1
	    nhigh   = 0				! Effectively discards all votes
	    nvote   = 0

	else if (bKeepGlitch) then		! Cmd line switch -keepglitch set: accept node

	    imedian = min(max(count/2,2),count)
	    rmedian = val_sort(imedian)

	    nlow    = 1
	    nhigh   = count
	    nvote   = count

	else if (near_star .eq. 1) then		! Close to bright star

	    imedian = min(max(count/2,2),count)
	    rmedian = val_sort(imedian)
	    !rstddev = ArrR4Stdev(0,imedian,val_sort,rmedian,i)

	    nlow    = 1
	    nhigh   = count
	    nvote   = count

	    nlow_old  = nlow
	    nhigh_old = nhigh
	    nvote_old = nvote

	    ! Note that this test gest ugly if the median is negative

	    dtest = 3.3*rmedian
	    !dtest = rmedian+3.0*rstddev
	    !print *, '2', rmedian, dtest, dtest1, count
	    do while (nhigh .gt. imedian .and. val_sort(nhigh) .gt. dtest)
		nhigh = nhigh-1
	    end do

	    if (nhigh .lt. nlow) then
		print *, (val_sort(i),i=1,count)
		print *, nlow_old, nhigh_old, nvote_old, imedian, rmedian
		print *, nlow, nhigh
		stop 'htm_combine, oops 1'
	    end if

	    dtest = min(0.1*rmedian,rmedian-50.0)
	    !dtest = rmedian-3.0*rstddev
	    !print *, '2', rmedian, dtest, dtest1, count
	    do while (nlow .lt. imedian .and. val_sort(nlow) .lt. dtest .and. btest(flag_sort(nlow),1))
		nlow = nlow+1
	    end do

	    if (nhigh .lt. nlow) then
		print *, (val_sort(i),i=1,count)
		print *, nlow_old, nhigh_old, nvote_old, imedian, rmedian
		print *, nlow, nhigh
		stop 'htm_combine, oops 2'
	    end if

	    nvote = nhigh-nlow+1

	    if (nvote .ne. nvote_old) then
		if (iSilent .lt. 2) then
		    if (nlow  .ne. nlow_old ) then
			i = 0
			i = i+Int2Str(nlow-nlow_old	, cStr(i+1:))
			i = i+Str2Str('/'		, cStr(i+1:))
			i = i+Int2Str(count		, cStr(i+1:))+1
			i = i+Str2Str('really low votes', cStr(i+1:))+1
			if (near_star .eq. 1) i = i+Str2Str('near star',cStr(i+1:))
			call Say(cSay,'W','dropped',cStr)
		    end if
		end if
		!if (iSilent .lt. 1) then
		!    if (nhigh .ne. nhigh_old) then
		!	i = 0
		!	i = i+Int2Str(nhigh_old-nhigh	, cStr(i+1:))
		!	i = i+Str2Str('/'		, cStr(i+1:))
		!	i = i+Int2Str(count		, cStr(i+1:))+1
		!	i = i+Str2Str('really high votes', cStr(i+1:))+1
		!	if (near_star .eq. 1) i = i+Str2Str('near star',cStr(i+1:))
		!	call Say(cSay,'W','dropped',cStr)
		!    end if
		!end if
		rmedian = ArrR4Median(nvote,val_sort(nlow),0.0,i,val_sort(nlow))
	    end if

	else

	    imedian = min(max(count/2,2),count)
	    rmedian = val_sort(imedian)
	    !rstddev = ArrR4Stdev(0,imedian,val_sort,rmedian,i)

	    nlow    = 1
	    nhigh   = count
	    nvote   = count

	    nlow_old  = nlow
	    nhigh_old = nhigh
	    nvote_old = nvote

	    dtest = max(1.25*rmedian,rmedian+50.0)
	    !dtest = rmedian+3.0*rstddev
	    !print *, '2', rmedian, dtest, dtest1, count
	    do while (nhigh .gt. imedian .and. val_sort(nhigh) .gt. dtest)
		nhigh = nhigh-1
	    end do

	    if (nhigh .lt. nlow) then
		print *, (val_sort(i),i=1,count)
		print *, nlow_old, nhigh_old, nvote_old, imedian, rmedian
		print *, nlow, nhigh
		stop 'htm_combine, oops 3'
	    end if

	    dtest = min(0.8*rmedian,rmedian-50.0)
	    !dtest = rmedian-3.0*rstddev
	    !print *, '2', rmedian, dtest, dtest1, count
	    do while (nlow .lt. imedian .and. val_sort(nlow) .lt. dtest .and. btest(flag_sort(nlow),1))
		nlow = nlow+1
	    end do

	    if (nhigh .lt. nlow) then
		print *, (val_sort(i),i=1,count)
		print *, nlow_old, nhigh_old, nvote_old, imedian, rmedian
		print *, nlow, nhigh
		stop 'htm_combine, oops 4'
	    end if

	    nvote = nhigh-nlow+1

	    if (nvote .ne. nvote_old) then
		if (iSilent .lt. 2) then
		    if (nlow  .ne. nlow_old ) then
			i = 0
			i = i+Int2Str(nlow-nlow_old	, cStr(i+1:))
			i = i+Str2Str('/'		, cStr(i+1:))
			i = i+Int2Str(count		, cStr(i+1:))+1
			i = i+Str2Str('really low votes', cStr(i+1:))+1
			if (near_star .eq. 1) i = i+Str2Str('near star',cStr(i+1:))
			call Say(cSay,'W','dropped',cStr)
		    end if
		end if
		!if (iSilent .lt. 1) then
		!    if (nhigh .ne. nhigh_old) then
		!	i = 0
		!	i = i+Int2Str(nhigh_old-nhigh	, cStr(i+1:))
		!	i = i+Str2Str('/'		, cStr(i+1:))
		!	i = i+Int2Str(count		, cStr(i+1:))+1
		!	i = i+Str2Str('really high votes', cStr(i+1:))+1
		!	if (near_star .eq. 1) i = i+Str2Str('near star',cStr(i+1:))
		!	call Say(cSay,'W','dropped',cStr)
		!    end if
		!end if
		rmedian = ArrR4Median(nvote,val_sort(nlow),0.0,i,val(nlow))
	    end if

	end if

	if (iType .eq. 0) then					! Mean
	    rgood = ArrR4Mean(nvote,val_sort(nlow),i)
	else if (iType .eq. 1) then				! Median
	    rgood = rmedian
	else if (iType .eq. 2) then				! Mean/median (ratio)
	    rgood = rmedian
	    if (rgood .ne. badval) rgood = ArrR4Mean(nvote,val_sort(nlow),i)/rgood
	else if (iType .eq. 3) then				! Mean-median (difference)
	    rgood = rmedian
	    if (rgood .ne. badval) rgood = ArrR4Mean(nvote,val_sort(nlow),i)-rgood
	else if (iType .eq. 4) then
	    rgood = ArrR4Stdev(0,nvote,val_sort(nlow),rgood,i)	! "Std"
	else if (iType .eq. 5) then				! Median/std (ratio)
	    rgood = rmedian
	    if (rgood .ne. badval) then
		rstd = ArrR4Stdev(0,nvote,val_sort(nlow),rgood,i)
		if (rstd .ne. badval) then
		    rgood = rgood/rstd
		else
		    rgood = badval
		end if
	    end if
	end if

	smei_htm_combine = nvote

	rbad = (ArrR4Total(nlow-1,val_sort)+ArrR4Total(count-nhigh,val_sort(nhigh+1)))/ArrR4Total(count,val_sort)

	return
	end
