C+
C NAME:
C	smei_htm
C PURPOSE:
C	Creates skymaps from individual SMEI data frames
C CATEGORY:
C	camera/for/htm
C CALLING SEQUENCE:
	program smei_htm
C INPUTS:
C	Input is controlled by command line arguments (see PROCEDURE).
C
C	<Pattern-file>	file with pattern
C			default: $DAT/smei/testcase/DATA_SMEI/c2pat_2004_140.grd
C			use SMEIDB? to get pattern from SMEI data base
C	<Frame-dir>	directory where the SMEI frames are located
C			default: SMEIDB? (the SMEI data base)
C	<Output-dir>	directory where the output files are written.
C			default: $TEMP
C OPTIONAL INPUTS:
C	-help		print some instructions and exit.
C
C	-firstorbit=<value>	default: 7223
C	-lastorbit=<value>	default: 7224
C			Orbits firstorbit through lastorbit are processed
C	-lowfraction=<value>	default: 0.0
C	-highfraction=<value>	default: 1.0
C			Only frames inside orbitfraction range
C			[lowfraction,highfraction] are used
C			(highfraction MUST be larger than lowfraction).
C
C	-camera=<value>	camera to be processed
C			default: 2
C	-mode=<value>	frame mode to be processed
C			default: 2 for cameras 1 and 2; 1 for camera 3
C	-level=<value>	frame mode to be processed
C			default: 11
C	-grd		output .grd files in addition to Fits file.
C	-keepglare	do not remove glare
C	-overwrite	create a new skymap if the Fits file already exists
C	-checkversion	create a new skymap if the Fits file already exists,
C			but only if it has a lower version number.
C			(if -overwrite is set then -checkversion is ignored)
C OUTPUTS:
C INCLUDE:
	include		'dirspec.h'
	include		'openfile.h'
	include		'filparts.h'
	include		'smei_frm_layout.h'
	include		'smei_frm_hdr.h'
	include		'smei_frm_hdrok.h'
	include		'smei_htm_dim.h'
C CALLS:
C	smei_orbit_time2, Say, cInt2Str, BadI4, BadR4, ArrR8Bad
C	Str2Str, Int2Str, Dbl2Str, iFilePath, bOpenFile, iFreeLun
C	smei_htm_make, smei_htm_grd, smei_htm_fts, smei_cal_init
C	smei_frm_ok, ForeignArgSet, smei_frm_read, Time2Str
C	smei_frm_getlist, smei_orbit2, smei_foreign, iHideLogical
C	iOSDeleteFile, iSetFileSpec, iGetFileSpec, ArrI4Copy
C	smei_hdr_str, smei_htm_init, smei_htm_sky, cDbl2Str
C EXAMPLE:
C	To run the testcase:
C
C	smei_htm $DAT/smei/testcast/DATA_SMEI
C PROCEDURE:
C >	A call to smei_htm has the structure:
C
C	smei_htm <List-file> <Pattern-file> <Frame-dir> <Output-dir>
C		-keyword1=<value1> -keyword2=<value2> ....
C
C >	Large-scale flatfields are read from $SMEIDB/flatfield (one of
C	c1_clsff.fts.gz, c2_clsff.fts.gz or c3_clsff.fts.gz.
C MODIFICATION HISTORY:
C	NOV-2004, Paul Hick (UCSD/CASS)
C	MAY-2005, Paul Hick (UCSD/CASS)
C	    Added processing of command line keywords nped_min and ndark_min
C	    to override the default test for accepting frames (based on setting
C	    of flag by href=smei_base=).
C	SEP-2005, Paul Hick (UCSD/CASS)
C	    Camera 3 glare removal is now also done using the glare model
C	    for the multiplier, instead of using a few constants.
C	NOV-2005, Paul Hick (UCSD/CASS), V2.0
C	    Modified to use different glare maps for cameras 2 and 3.
C	NOV-2005, Paul Hick (UCSD/CASS), V2.1
C	    Added another low resolution map to output file (fraction
C	    of orbit in seconds since start of orbit).
C	    The lowres maps for the 'glare angles' are now always calculated.
C	    They used to be set zero if glare subtraction was suppressed.
C	    All lowres maps for camera 2 are run through GridSphere2D to
C	    fill holes near the equatorial poles.
C	DEC-2005, Paul Hick (UCSD/CASS), V2.11
C	    Changed format of several entries in Fits header
C	    Modified to deal with presence of -overwrite on cmd line
C	DEC-2005, Paul Hick (UCSD/CASS), V2.12
C	    Added keyword MODE to Fits header
C	    Added processing of SMEI_HTM keyword to force overwrite of
C	    skymaps with a lower version number.
C	    Added keyword IMG_TYPE to Fits header
C	JAN-2006, Paul Hick (UCSD/CASS), V3.00
C	    Introduced new definition of orbit start times based on
C	    spacecraft ephemeris data (see smei_sgp4_orbits.pro).
C	JAN-2006, Paul Hick (UCSD/CASS), V3.01
C	    Added keyword nshutter_open_skip to enable skipping of
C	    frames after the shutter opens (see smei_frm_ok).
C	JAN-2006,  Paul Hick (UCSD/CASS; pphick@ucsd.edu), V4.00
C	    Fixed bug in smei_htm_sky (the slope of the background
C	    near stars was incorrect due to a wrong array index).
C	    Reduced memory footprint by only processing HTM nodes
C	    on the sky near the frame being processed.
C-
	character	cSay*10			/'smeidb_htm'/
	double precision version		/4.00d0/

	logical		ForeignArgSet
	logical		bOpenFile
	logical		smei_frm_read
	logical		smei_frm_ok
	character	cDbl2Str*14
	character	cInt2Str*14
	integer		Str2Str
	integer		Dbl2Str
	integer		Time2Str
	integer		BadI4
	integer		smei_frm_getlist

	parameter	(nVar=5)
	character	cVar(nVar)*(FIL__LENGTH)	/nVar*' '/
	character	cArg	  *(FIL__LENGTH)
	character	cStr	  *(FIL__LENGTH*2)
	character	cName	  *(FIL__LENGTH)

	integer		TBeg (2)
	integer		TEnd (2)
	integer		TLow (2)
	integer		THigh(2)

	double precision hdr  (SMEI__HDR_N)
	double precision hdrok(SMEI__HDROK_N)
	double precision forbit(2)	! 0.15 starts 15% through orbit
	double precision dorbit

	real		frame(SMEI__FRM_NPIX)

	logical		bOneSky
	logical		bDig
	logical		bSilent
	logical		bGo

	iBad = BadI4()
	rBad = BadR4()

	! Pick up command line arguments
	! cVar(2) is name of pattern file, or blank string
	! cVar(3) is source directory
	! cVar(4) is destination directory

	call smei_foreign(4,cVar(2),cVar(3),cVar(4),0,TBeg,TEnd,forbit,icam,mode,cArg)

	if (ForeignArgSet(cArg,'help')) then

	    write (*,'(3X,A,T38,A)') cSay,' ',
     &		'   <pattern_file>',' ',
     &		'   '//cSwitch(:iSwitch)//'start_time=<start_time>'	,'YYYY_DOY_hhmmss, orbit nr',
     &		'   '//cSwitch(:iSwitch)//'stop_time=<stop_time>'	,'YYYY_DOY_hhmmss, orbit nr',
     &		'   '//cSwitch(:iSwitch)//'camera=<1,2,3>'		,' ',
     &		'   '//cSwitch(:iSwitch)//'mode=<0,1,2>'		,'default: 2 for cam 1,2; 1 for cam 3',
     &		'   '//cSwitch(:iSwitch)//'source=<dir>'		,'default: SMEIDB?',
     &		'   '//cSwitch(:iSwitch)//'digsource'			,'default: off (on for SMEIDB?)',
     &		'   '//cSwitch(:iSwitch)//'destination=<dir>'		,'default: $TEMP',
     &		'   '//cSwitch(:iSwitch)//'lowfraction=<lowfraction>'	,'default: 0.0',
     &		'   '//cSwitch(:iSwitch)//'highfraction=<highfraction>'	,'default: 1.0',
     &		'   '//cSwitch(:iSwitch)//'level=<level>'		,'default: 11 (mode 1/2) or 12 (mode 0)',
     &		'   '//cSwitch(:iSwitch)//'onesky'			,'default: off',
     &		'   '//cSwitch(:iSwitch)//'keepglare'			,'default: off',
     &		'   '//cSwitch(:iSwitch)//'silent'			,'default: off',
     &		'   '//cSwitch(:iSwitch)//'nped_min=<nped_min>'		,'overrides default frame selection',
     &		'   '//cSwitch(:iSwitch)//'ndark_min=<ndark_min>'	,'overrides default frame selection',
     &		'   '//cSwitch(:iSwitch)//'version'			,'print version number and exit',
     &		'   '//cSwitch(:iSwitch)//'overwrite'			,'overwrite skymaps',
     &		'   '//cSwitch(:iSwitch)//'checkversion'		,'overwrite skymaps with lover version number',
     &		'   '//cSwitch(:iSwitch)//'nshutter_open_skip'		,'number of frames skipped after shutter opens',
     &		'   '//cSwitch(:iSwitch)//'median'			,'calculate median map instead of mean map',
     &		'   '//cSwitch(:iSwitch)//'keepglitches'		,'suppress glitch removal (CR,space debris)'

	    call Say(cSay,'S','Stop','End syntax')

	end if

	if (ForeignArgSet(cArg,'version'))			! Print version number
     &	    call Say(cSay,'S','Stop','Version '//cDbl2Str(version,2))

	if (TBeg(1) .eq. iBad .or. TEnd(1) .eq. iBad) call Say(cSay,'E','times',
     &		'please, specify begin and end time#'//
     &		'type "'//cSay//' '//cSwitch(:iSwitch)//'help" for more info')

	if (icam .eq. iBad) call Say(cSay,'E','camera',
     &		'please, specify camera#'//
     &		'type "'//cSay//' '//cSwitch(:iSwitch)//'help" for more info')

	bOneSky	= ForeignArgSet(cArg,'onesky'	)
	bDig	= ForeignArgSet(cArg,'digsource') 
	bSilent = ForeignArgSet(cArg,'silent'	)

	if (bOneSky) then

	    call smei_orbit2(TBeg,iorbit_first,dorbit)
	    iorbit_first = nint(iorbit_first+dorbit)
	    iorbit_last  = iorbit_first

	    i = 0
	    i = i+Time2Str('SMEI',TBeg,cStr(i+1:))
	    i = i+Str2Str('-',cStr(i+1:))
	    i = i+Time2Str('SMEI',TEnd,cStr(i+1:))

	else

	    call smei_orbit2(TBeg,iorbit_first,dorbit)
	    iorbit_first = nint(iorbit_first+dorbit)

	    call smei_orbit2(TEnd,iorbit_last ,dorbit)
	    iorbit_last  = nint(iorbit_last +dorbit)

	    iorbit_last  = max(iorbit_last-1,iorbit_first)

	    i = 0
	    if (iorbit_last .eq. iorbit_first) then
		i = i+Str2Str('orbit'		, cStr(i+1:))+1
		i = i+Int2Str(iorbit_first	, cStr(i+1:))
	    else
		i = i+Str2Str('orbits'		, cStr(i+1:))+1
		i = i+Int2Str(iorbit_first	, cStr(i+1:))+1
		i = i+Str2Str('-'		, cStr(i+1:))+1
		i = i+Int2Str(iorbit_last	, cStr(i+1:))
	    end if

	end if

	i = i+Str2Str (', camera'	, cStr(i+1:))+1
	i = i+Int2Str (icam		, cStr(i+1:))
	i = i+Str2Str (', mode'		, cStr(i+1:))+1
	i = i+Int2Str (mode		, cStr(i+1:))
	i = i+Str2Str('#read from'	, cStr(i+1:))+1
	i = i+iHideLogical(cVar(3)	, cStr(i+1:))
	if (bDig) i = i+Str2Str(' (digging)', cStr(i+1:))
	i = i+Str2Str('#write to'	, cStr(i+1:))+2
	i = i+iHideLogical(cVar(4)	, cStr(i+1:))
	if (cVar(2) .ne. ' ') then
	    i = i+Str2Str('#pattern'	, cStr(i+1:))+1
	    i = i+iHideLogical(cVar(2)	, cStr(i+1:))		! Pattern file
	end if

	call Say(cSay,'I','do',cStr)

	call smei_cal_init()

	if (bOneSky) then
	    call ArrI4Copy(2,TBeg,TLow )
	    call ArrI4Copy(2,TEnd,THigh)
	    call ArrR8Bad (2,forbit)
	end if

	do iorbit=iorbit_first,iorbit_last			! Loop over orbits

	    bGo = .TRUE.

	    if (.not. bOneSky) then
		call smei_orbit_time2(iorbit,forbit(1), TLow )	! Time at orbit i+lofrac
		call smei_orbit_time2(iorbit,forbit(2), THigh)	! Time at orbit i+hifrac
	    end if

	    ! Get list of file names for current orbit.
	    ! The names are stored in file cStr (last argument)

	    iframe = 0
	    nframe = smei_frm_getlist(TLow,THigh,icam,mode,bDig,cVar(3),cStr)

	    if (nframe .gt. 0) then

		! Process all frames stored in file cStr.

		iRecl = 0
		if (.not. bOpenFile(OPN__TEXT+OPN__REOPEN+OPN__NOMESSAGE,iU,cStr,iRecl)) then
		    i = iOSDeleteFile(cStr)
		    call Say(cSay,'E','#'//cStr,'error opening list with frame names')
		end if

		i = iScratchLun(iU)				! Mark cStr as scratch file
		read (iU,'(A)',iostat=i) cVar(1)

		do while (i .eq. 0 .and. bGo)			! Process all frames in orbit

		    if (smei_frm_read(OPN__REOPEN+OPN__NOMESSAGE,cVar(1),SMEI__FRM_NPIX,i,j,k,frame,hdr,headroom)) then

			i = iSetFileSpec(cVar(1))
			i = iGetFileSpec(FIL__NAME,FIL__NAME,cName)

			if ( smei_frm_ok(cArg,cName,hdr,hdrok,bSilent) ) then

			    iframe = iframe+1

			    cStr = cName
			    if (iframe .eq. 1) call Say(cSay,'I',cStr,'starts orbit '//cInt2Str(iorbit))

			    ! Pick up name of calibration pattern, and (for cam 3, mode 1) the
			    ! on-the-fly orbital (difference) pattern.

			    call smei_hdr_str(SMEI__HDR_CAL_PATTERN,hdr,cVar(2))
			    if (icam .eq. 3 .and. mode .eq. 1) call smei_hdr_str(SMEI__HDR_ORB_PATTERN,hdr,cVar(5))

			    ! Currently bGo is only used when the first frame for an orbit is
			    ! processed to check whether the orbit needs to be processed or not.
			    ! For the 2nd and later frames bGo is always .TRUE.

			    call smei_htm_init(version,hdr,cVar,cArg,bGo)

			    ! Process all pixels in the FOV. Each pixel contributes a number
			    ! of votes to the pool of active votes, and may add to the number
			    ! of active nodes.

			    if (bGo) call smei_htm_sky(iframe,hdr,frame)

			end if

		    end if

		    read (iU,'(A)',iostat=i) cVar(1)

		end do

	    end if

	    ! Orbit finished. iframe frames have been processed.
	    ! If iframe not zero then process the orbit.

	    if (.not. bGo) then

		continue

	    else if (iframe .eq. 0) then

		if (bOneSky) then
		    i = 0
		    i = i+Time2Str('SMEI',TLow,cStr(i+1:))+1
		    i = i+Str2Str ('-',cStr(i+1:))+1
		    i = i+Time2Str('SMEI',THigh,cStr(i+1:))+1
		    i = i+Str2Str ('has 0 frames',cStr(i+1:))
		    call Say(cSay,'I','period',cStr)
		else
		    call Say(cSay,'I','orbit '//cInt2Str(iorbit),'has 0 frames')
		end if

	    else

		if (bOneSky) then

		    i = 0
		    i = i+Time2Str('SMEI',TLow,cStr(i+1:))
		    i = i+Str2Str('-'	  , cStr(i+1:))
		    i = i+Time2Str('SMEI',THigh,cStr(i+1:))+1
		    i = i+Str2Str('has'	  , cStr(i+1:))+1
		    i = i+Int2Str(iframe  , cStr(i+1:))
		    i = i+Str2Str('/'	  , cStr(i+1:))
		    i = i+Int2Str(nframe  , cStr(i+1:))+1
		    i = i+Str2Str('frames', cStr(i+1:))

		    call Say(cSay,'I','period',cStr)

		else

		    call Say(cSay,'I','#'//cStr,'ends orbit '//cInt2Str(iorbit))

		    i = 0
		    i = i+Int2Str(iframe   , cStr(i+1:))
		    i = i+Str2Str('/'	   , cStr(i+1:))
		    i = i+Int2Str(nframe   , cStr(i+1:))+1
		    i = i+Str2Str('frames between fraction', cStr(i+1:))+1
		    i = i+Dbl2Str(forbit(1), 3, cStr(i+1:))+1
		    i = i+Str2Str('and'	   , cStr(i+1:))+1
		    i = i+Dbl2Str(forbit(2), 3, cStr(i+1:))

		    call Say(cSay,'I','orbit '//cInt2Str(iorbit),cStr)

		end if

		call smei_htm_make()				! Make final maps
		call smei_htm_fts(version,forbit,nframe,iframe)	! Write fits file

	    end if

	    iU = iFreeLun(-iU)

	end do					! Loop over all orbits

	call Say(cSay,'S','Stop','All done')	! Sets exit code to 1

	end
